﻿Scriptname _SLSubmitScene extends Quest  

SexLabFramework property SexLab auto
_SLSubmitConfig Property _SLConfig auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitFunctions Property _SLFunctions auto
zadLibs Property Libs auto
zadxLibs Property LibsX auto
PlayerVampireQuestScript Property PVQ Auto

Actor Property playerRef Auto
Keyword Property Vampire Auto
_SLSubmitTargetSelect property TargetSelect auto
GlobalVariable Property _SLSubmitBoundGlobal  Auto
GlobalVariable Property _SLSubmitBleedoutGlobal  Auto
GlobalVariable Property _SLSubmitBeatenGlobal Auto
GlobalVariable Property _SLSubmitBribeGlobal  Auto   
GlobalVariable Property _SLSubmitFailurePenalty  Auto
GlobalVariable Property _SLSubmitHardcoreBindings Auto
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitFSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitSpeechBonus  Auto
GlobalVariable Property _SLSubmitHotkeyGlobal Auto
GlobalVariable Property _SLSubmitSexPartner Auto  
GlobalVariable Property _SLSubmitJailed Auto  
GlobalVariable Property _SLSubmitIndecencyGlobal Auto  
Float Property SpeechModifier  Auto 
Idle Property _SLSubmitKillMove  Auto  
Idle Property _SLSubmitFeed Auto
Idle Property _SLSubmitHug Auto
Spell Property _SLSubmitGuard  Auto  
SPELL Property _SLSubmitBound  Auto
SPELL Property _SLSubmitShout  Auto
SPELL Property _SLSubmitSmack  Auto
SPELL Property _SLSubmitAmbush  Auto
SPELL Property _SLSubmitVShout  Auto
SPELL Property _SLSubmitAssign  Auto  
SPELL Property _SLSubmitSurrender  Auto  
SPELL Property _SLSubmitReset  Auto  
Spell Property _SLSubmitBully Auto
Spell Property _SLSubmitIndecency  Auto  
Spell Property _SLSubmitFollowerSpell Auto
Spell Property _SLSubmitHelp  Auto  
Package Property BullyPackage Auto
Spell Property Privacy Auto
Spell Property VampDisease Auto
MagicEffect Property VampSick Auto
Int Property Gold  Auto  
Int Property FGold  Auto  
MiscObject Property Gold001  Auto  
ReferenceAlias Property ActorSurrender1  Auto  
ReferenceAlias Property ActorSurrender2  Auto  
ReferenceAlias Property ActorAssailant1  Auto  
ReferenceAlias Property ActorAssailant2  Auto  
ReferenceAlias Property ActorAssailant3  Auto  
ReferenceAlias Property ActorAssailant4  Auto  
ReferenceAlias Property ActorAssailant5  Auto  
ReferenceAlias Property ActorAssailant6  Auto  
ReferenceAlias Property ActorFollower  Auto  
ReferenceAlias Property ActorFollowerTemp  Auto  
ReferenceAlias Property ActorSexPartner  Auto  
ReferenceAlias Property ActorPostSexPartner  Auto  
ReferenceAlias Property ActorVAssailant1  Auto  
ReferenceAlias Property ActorBully  Auto  
Keyword Property ActorTypeNPC  Auto  
Faction Property Companion Auto
Faction Property OrcGuard Auto
Faction Property _SLSubmitFaction Auto
Faction Property _SLSubmitBusyFaction Auto
Faction Property _SLSubmitVictimFaction Auto
Faction Property _SLSubmitLoverFaction Auto
Faction Property _SLSubmitPartnerFaction Auto
Faction Property _SLSubmitRejectedFaction Auto
Faction Property _SLSubmitSatedFaction Auto
Faction Property _SLSubmitTempRank1Faction Auto
Topic Property _SLSubmitBlissTopic Auto
Topic Property _SLSubmitRescueTopic Auto
Race Property Werewolf Auto
Race Property Draugr Auto
Race Property DraugrMagic Auto
Race Property Falmer Auto
Race VampireLord
Outfit Property _SLSubmitOutfit Auto
Armor Property _SLSubmitCuffs Auto
Armor Property _SLSubmitCuffs2 Auto

Weapon Property MainHand  Auto  
Weapon Property OffHand  Auto  
Spell Property Slap Auto
Spell Property LSpell Auto
Spell Property RSpell Auto
Spell Property _SLSubmitUnarmed Auto
Armor Property Shield Auto
Armor Property Body Auto
Armor Property Boot Auto
Armor Property Glove Auto
Armor Property Helm Auto
Armor Property Necklace Auto
Armor Property Ring Auto

Weapon Property VictimWeapon1  Auto  
Weapon Property VictimWeapon2  Auto  

Book Property _SLSubmitLetter  Auto
Book Property _SLSubmitLetterBelethorRecepit  Auto
Book Property _SLSubmitLetterAvalAtheronRecepit  Auto
Book Property _SLSubmitLetterSaymaRecepit  Auto  
Book Property _SLSubmitLetterSolafRecepit  Auto  
Book Property _SLSubmitLetterBersiRecepit  Auto    
Book Property _SLSubmitAvalAtheronLetter  Auto
Book Property _SLSubmitSaymaLetter  Auto  
Book Property _SLSubmitSolafLetter  Auto  
Book Property _SLSubmitBersiLetter  Auto  

GlobalVariable Property WICourierItemCount  Auto  
ObjectReference Property CourierChest  Auto 

ObjectReference Property MerchantWhiterunBelethorsGoodsChest  Auto 
ObjectReference Property MerchantWindhelmAvalAtheronChest  Auto  
ObjectReference Property MerchantSolitudeBitsAndPieces  Auto  
ObjectReference Property MerchantFalkreathGrayPineGoodsChest  Auto  
ObjectReference Property MerchantRiftenPawnedPrawnChest  Auto   

Bool Dawnguard
Race DLC1VampireBeast
Armor[] mDevices

; [0 = Belt, 1 = vagPlug, 2 = analPlug]
Armor[] pBelt
Armor[] fBelt

function WRT(float waitFor)
	waitFor += Utility.GetCurrentRealTime()
	while Utility.GetCurrentRealTime() < waitFor
		Utility.Wait(0.1)
	endWhile
endFunction

Function Surrender(Actor Victim, Actor Player)
	_SLFunctions.Log("Surrender(" + Victim + "," + Player + ")")
	
	;Game.DisablePlayerControls()
	ActorSurrender1.ForceRefTo(Victim)
	Victim.StopCombat()		
	If (!Player.HasSpell(_SLSubmitGuard) && !_SLQuest.IsHostileNPC(Victim))
		Player.AddSpell(_SLSubmitGuard, false)
	EndIf
	Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
	WRT(0.5)
	Debug.SendAnimationEvent(Victim, "IdleSurrender")
	WRT(2.0)
	Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
	float zOffset = Victim.GetHeadingAngle(Player)
	Victim.MoveTo(Player, 100.0 * Math.Sin(Player.GetAngleZ()), 100.0 * Math.Cos(Player.GetAngleZ()))
	Victim.SetAngle(Victim.GetAngleX(), Victim.GetAngleY(), Victim.GetAngleZ() + zOffset)
	Debug.SendAnimationEvent(Victim, "IdleKneelingEnter")
	Game.EnablePlayerControls()
EndFunction

Function Strip(Actor Target)
	_SLFunctions.Log("Strip(" + Target + ")")

	If (!PlayerRef.IsInCombat())
		MainHand = Target.getEquippedWeapon()
		OffHand = Target.getEquippedWeapon(True)
		Shield = Target.getEquippedShield()
		Body = Target.GetWornForm(0x00000004) as Armor
		Boot = Target.GetWornForm(0x00000180) as Armor
		Glove = Target.GetWornForm(0x00000018) as Armor
		Helm = Target.GetWornForm(0x00001803) as Armor
		Necklace = Target.GetWornForm(0x00000020) as Armor
		Ring = Target.GetWornForm(0x00000040) as Armor
		WRT(0.1)
		Target.UnequipAll()
	Else
		If(_SLConfig.debugActive)
			Debug.Notification("You are in combat!")
		EndIf
	EndIf
EndFunction

Function Rob(Actor Victim, Actor Player)
	_SLFunctions.Log("Rob(" + Victim + "," + Player + ")")

	If (!PlayerRef.IsInCombat())
		Gold = Victim.GetGoldAmount()
		Victim.RemoveItem(Gold001, Gold)
		Player.AddItem(Gold001, Gold)
		Victim.MoveTo(Player, 100.0 * Math.Sin(Player.GetAngleZ()), 100.0 * Math.Cos(Player.GetAngleZ()))
		Debug.SendAnimationEvent(Victim, "IdleKneelingEnter")
		WRT(1.0)
		Victim.ShowGiftMenu(False, None, True, False)
	Else
		If(_SLConfig.debugActive)
			Debug.Notification("You are in combat!")
		EndIf
	EndIf
EndFunction

Function Sex(Actor Victim, Actor Player)
	_SLFunctions.Log("Sex(" + Victim + "," + Player + ")")

	If (!Victim.IsInFaction(_SLSubmitBusyFaction))
		Victim.AddToFaction(_SLSubmitBusyFaction)
	EndIf
	
	Debug.SendAnimationEvent(Victim, "IdleCowering")
	If Player.IsWeaponDrawn()		
		Player.SheatheWeapon()	
		WRT(2.0)
	EndIf
	If (!PlayerRef.IsInCombat())
		sslThreadModel Model = SexLab.NewThread()
		actor[] activeActors = new actor[2]
		activeActors[0] = Victim
		activeActors[1] = Player
		If(_SLConfig.VictimActive)
			activeActors = SexLab.SortActors(activeActors)
		EndIf
		Model.AddActor(activeActors[0], activeActors[0] == Victim)
		Model.AddActor(activeActors[1], activeActors[1] == Victim)
		Model.DisableLeadIn()
		Model.DisableUndressAnimation(Victim)
		sslBaseAnimation[] anims = SexLab.GetAnimationsByType(2, aggressive=true)
		Model.SetAnimations(anims)
		RegisterForModEvent("AnimationEnd_PostRape", "PostRape")
		Model.SetHook("PostRape")
		Model.StartThread()
	Else
		If(_SLConfig.debugActive && !_SLConfig.RobActive)
			Debug.Notification("You are in combat!")
		EndIf
		PostRob(Victim, 	PlayerRef)
	EndIf
EndFunction

Function FollowerSex(Actor[] activeActors)
	_SLFunctions.Log("FollowerSex(" + activeActors + ")")
	
	If (!Victim.IsInFaction(_SLSubmitBusyFaction))
		Victim.AddToFaction(_SLSubmitBusyFaction)
	EndIf
	
	Debug.SendAnimationEvent(Victim, "IdleCowering")
	If PlayerRef.IsWeaponDrawn()
		PlayerRef.SheatheWeapon()	
		WRT(2.0)
	EndIf
	Actor Victim = activeActors[0]
	Actor Follower = activeActors[1]
	WRT(0.5)
	If Follower.IsWeaponDrawn()		
		Follower.SheatheWeapon()	
		WRT(2.0)
	EndIf
	If (!PlayerRef.IsInCombat())
		If(_SLConfig.VictimActive)
			activeActors = SexLab.SortActors(activeActors, femaleFirst=true)
		EndIf
		if activeActors.Length == 3
			Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
			ActorSurrender1.Clear()
			sslBaseAnimation[] anims = SexLab.GetAnimationsByType(3)	
			RegisterForModEvent("AnimationEnd_PostRape", "PostRape")
			SexLab.StartSex(activeActors, anims, victim = Victim, hook="PostRape")
		elseif activeActors.Length == 2
			Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
			ActorSurrender1.Clear()
			sslBaseAnimation[] anims = SexLab.GetAnimationsByType(2, aggressive=true)
			RegisterForModEvent("AnimationEnd_PostRape", "PostRape")
			SexLab.StartSex(activeActors, anims, victim = Victim, hook="PostRape")
		endif
	Else
		PostRob(Victim, 	PlayerRef)
	EndIf
EndFunction

event PostRape(string eventName, string argString, float argNum, form sender)
	_SLFunctions.Log("PostRape(" + eventName + "," + argString + "," + argNum + "," + sender + ")")

	sslThreadController thread = SexLab.HookController(argString)
	Actor Victim = thread.GetVictim()
	ActorSurrender1.Clear()
	Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
	WRT(0.5)
	If (Victim.IsInFaction(_SLSubmitFaction))
		Victim.RemoveFromFaction(_SLSubmitFaction)
	EndIf
	If (!Victim.IsInFaction(_SLSubmitVictimFaction))
		Victim.AddToFaction(_SLSubmitVictimFaction)
	EndIf
	Debug.SendAnimationEvent(Victim, "BleedOutStart")	
	Victim.SetLookAt(PlayerRef)
	PlayerRef.RemoveSpell(_SLSubmitGuard)
	WRT(2.5)
	Debug.SendAnimationEvent(Victim, "BleedOutStart")	
	WRT(2.5)
	Debug.SendAnimationEvent(Victim, "BleedOutStart")	
	WRT(5.0)
	Debug.SendAnimationEvent(Victim, "BleedOutStop")
	WRT(2.5)
	float zOffset = Victim.GetHeadingAngle(PlayerRef)
	Victim.SetAngle(Victim.GetAngleX(), Victim.GetAngleY(), Victim.GetAngleZ() + zOffset)
	Debug.SendAnimationEvent(Victim, "IdleKneelingEnter")
	WRT(1.0)
	Victim.EquipItemEx( MainHand,1, false, true)
	Victim.EquipItemEx( OffHand,2, false, true)
	Victim.EquipItemEx( Shield, 0, false, true)
	Victim.EquipItemEx( Body, 0, false, true)
	Victim.EquipItemEx( Boot, 0, false, true)
	Victim.EquipItemEx( Glove, 0, false, true)
	Victim.EquipItemEx( Helm, 0, false, true)
	Victim.EquipItemEx( Necklace, 0, false, true)
	Victim.EquipItemEx( Ring, 0, false, true)
	WRT(1.5)
	Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
	Victim.SetRelationshipRank(PlayerRef,-2)
	If (Victim.HasLOS(PlayerRef) && !PlayerRef.IsInCombat() && !_SLQuest.IsHostileNPC(Victim))
		_SLSubmitHelp.Cast(PlayerRef)
	EndIf
	WRT(1.0)
	Debug.SendAnimationEvent(Victim, "IdleWipeBrow")
	If (Victim.IsInFaction(_SLSubmitBusyFaction))
		Victim.RemoveFromFaction(_SLSubmitBusyFaction)
	EndIf
	Victim.ClearLookAt()
	UnregisterForModEvent("AnimationEnd_PostRape")
endEvent

Function PostRob(Actor Victim, Actor Player)
	_SLFunctions.Log("PostRob(" + Victim + "," + Player + ")")

	ActorSurrender1.Clear()
	Victim.SetLookAt(Player)
	WRT(1.0)
	If (Victim.IsInFaction(_SLSubmitFaction))
		Victim.RemoveFromFaction(_SLSubmitFaction)
	EndIf
	If (!Victim.IsInFaction(_SLSubmitVictimFaction))
		Victim.AddToFaction(_SLSubmitVictimFaction)
	EndIf
	Debug.SendAnimationEvent(Victim, "IdleCowering")
	Player.RemoveSpell(_SLSubmitGuard)
	WRT(10.0)
	float zOffset = Victim.GetHeadingAngle(Player)
	Victim.SetAngle(Victim.GetAngleX(), Victim.GetAngleY(), Victim.GetAngleZ() + zOffset)
	Debug.SendAnimationEvent(Victim, "IdleKneelingEnter")
	WRT(1.0)
	Victim.EquipItemEx( MainHand,1, false, true)
	Victim.EquipItemEx( OffHand,2, false, true)
	Victim.EquipItemEx( Shield, 0, false, true)
	Victim.EquipItemEx( Body, 0, false, true)
	Victim.EquipItemEx( Boot, 0, false, true)
	Victim.EquipItemEx( Glove, 0, false, true)
	Victim.EquipItemEx( Helm, 0, false, true)
	Victim.EquipItemEx( Necklace, 0, false, true)
	Victim.EquipItemEx( Ring, 0, false, true)
	WRT(1.5)
	Debug.SendAnimationEvent(Victim, "IdleForceDefaultState")
	Victim.SetRelationshipRank(Player,-2)
	If (Victim.HasLOS(Player) && !PlayerRef.IsInCombat() && !_SLQuest.IsHostileNPC(Victim))
		_SLSubmitHelp.Cast(Player)
	EndIf
	WRT(1.0)
	Debug.SendAnimationEvent(Victim, "IdleWipeBrow")
	If (Victim.IsInFaction(_SLSubmitBusyFaction))
		Victim.RemoveFromFaction(_SLSubmitBusyFaction)
	EndIf
	Victim.ClearLookAt()
EndFunction

Function Kill(Actor Target, Actor Caster)
	_SLFunctions.Log("Kill(" + Target + "," + Caster + ")")

	ActorSurrender1.ForceRefTo(Target)
	Game.DisablePlayerControls()
	Caster.AddSpell(_SLSubmitGuard, false)
	Target.StartCombat(Caster)
	_SLFunctions.UnArm(Caster)
	WRT(0.5)
	If !Caster.IsWeaponDrawn()		
		Caster.DrawWeapon()	
		WRT(0.5)
	EndIf
	Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
	If (Target.GetSleepState() == 3)
		Target.MoveTo(Target, 200.0 * Math.Sin(Target.GetAngleZ()), 200.0 * Math.Cos(Target.GetAngleZ()))
		Caster.MoveTo(Target, -30.0 * Math.Sin(Target.GetAngleZ()), -30.0 * Math.Cos(Target.GetAngleZ()))
	ElseIf (Target.GetSitState() != 0)	
		Target.MoveTo(Target, 100.0 * Math.Sin(Target.GetAngleZ()), 100.0 * Math.Cos(Target.GetAngleZ()))
		Debug.SendAnimationEvent(Target, "IdleKneelingEnter")
		WRT(0.1)
		Caster.MoveTo(Target, -30.0 * Math.Sin(Target.GetAngleZ()), -30.0 * Math.Cos(Target.GetAngleZ()))
	Else
		;Target.MoveTo(Caster, 15.0 * Math.Sin(Caster.GetAngleZ()), 15.0 * Math.Cos(Caster.GetAngleZ()))
	EndIf
	Target.startCombat(Caster)
	Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
	WRT(0.5)
	Debug.SendAnimationEvent(Target, "IdleSurrender")
	WRT(1.0)
	Target.MoveTo(Caster, 15.0 * Math.Sin(Caster.GetAngleZ()), 15.0 * Math.Cos(Caster.GetAngleZ()))
	float zOffset = Target.GetHeadingAngle(Caster)
	Target.SetAngle(Target.GetAngleX(), Target.GetAngleY(), Target.GetAngleZ() + zOffset)
	If (Caster.HasKeyword(Vampire))
		Caster.StartVampireFeed(Target)
		_SLFunctions.SubmitFeed()
		Target.StopCombat()
		Target.Kill()
	Else
		Debug.SendAnimationEvent(Caster, "AttackStartH2HRight")
		WRT(0.4)
		Caster.PlayIdleWithTarget(_SLSubmitKillMove, Target)
		WRT(3.0)	
	EndIf
	If Caster.IsWeaponDrawn()		
		Caster.SheatheWeapon()	
		WRT(0.5)
	EndIf
	_SLFunctions.ReArm(Caster)
	If !Caster.IsWeaponDrawn()		
		Caster.DrawWeapon()	
	EndIf
	Game.EnablePlayerControls()
	ActorSurrender1.Clear()
	WRT(10.0)
	Caster.RemoveSpell(_SLSubmitGuard)
EndFunction

Function PlayerSurrender(Actor Victim, Actor Victor, Actor Victor2)
	_SLFunctions.Log("PlayerSurrender(" + Victim + "," + Victor + "," + Victor2 + ")")

	VictimWeapon1 = Victim.getEquippedWeapon()
	VictimWeapon2 = Victim.getEquippedWeapon(True)
	Game.DisablePlayerControls()
	WRT(0.1)
	If Victim.IsWeaponDrawn()		
		Victim.SheatheWeapon()	
		WRT(2.0)
	EndIf
	WRT(0.5)
	If (Victor.HasKeyword(ActorTypeNPC))
		Slap.Cast(Victor)
		If (Victim.IsSneaking())
			Victim.StartSneaking()
			WRT(0.5)
		EndIf
		If (_SLSubmitBoundGlobal.GetValue() == 0)
			Debug.SendAnimationEvent(Victim, "IdleSurrender")
		EndIf
		WRT(2.0)
		Victor.MoveTo(Victim, 60.0 * Math.Sin(Victim.GetAngleZ()), 60.0 * Math.Cos(Victim.GetAngleZ()))
		float zOffset1 = Victor.GetHeadingAngle(Victim)
		Victor.SetAngle(Victor.GetAngleX(), Victor.GetAngleY(), Victor.GetAngleZ() + zOffset1)
		If (_SLSubmitBoundGlobal.GetValue() == 0)
			Debug.SendAnimationEvent(Victim, "IdleSurrender")
		EndIf
		_SLFunctions.UnArm2(Victor)
		WRT(0.2)
		_SLSubmitSurrenderGlobal.SetValue(3)
		If (Victor.HasKeyword(Vampire))
			ActorVAssailant1.ForceRefTo(ActorAssailant1.GetActorRef())
			WRT(0.1)
			ActorAssailant1.Clear()
			WRT(0.1)
			If Victor.IsWeaponDrawn()		
				Victor.SheatheWeapon()	
				WRT(2.0)
			EndIf
			WRT(1.0)
			Victor.PlayIdleWithTarget(_SLSubmitFeed, Victim)
			WRT(3.0)
			If (!Victim.HasKeyword(Vampire) && !Victim.HasMagicEffect(VampSick))
				Victor.DoCombatSpellApply(VampDisease, Victim)
			EndIf
			ActorAssailant1.ForceRefTo(ActorVAssailant1.GetActorRef())
			WRT(0.1)
			ActorVAssailant1.Clear()
			WRT(0.1)
		Else
			If (_SLSubmitBleedoutGlobal.GetValue() == 0)
				Debug.SendAnimationEvent(Victor, "attackStart")
				WRT(0.1)
				Debug.SendAnimationEvent(Victor, "attackPowerStartH2HCombo")
				WRT(0.2)
			Else
				Debug.SendAnimationEvent(Victor, "JumpLand")
			EndIf
			Debug.SendAnimationEvent(Victim, "StaggerStart")
			If (ActorFollower.GetActorRef() != None)
				If (Victor != Victor2 && Victor2 != None)
					Victor2.MoveTo(ActorFollower.GetActorRef(), 60.0 * Math.Sin(ActorFollower.GetActorRef().GetAngleZ()), 60.0 * Math.Cos(ActorFollower.GetActorRef().GetAngleZ()))
					float zOffset2 = Victor2.GetHeadingAngle(ActorFollower.GetActorRef())
					Victor2.SetAngle(Victor2.GetAngleX(), Victor2.GetAngleY(), Victor2.GetAngleZ() + zOffset2)
				EndIf
				Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "StaggerStart")
			EndIf
			WRT(1.3)
		EndIf
		If (_SLConfig.StealActive && _SLQuest.IsHostileNPC(Victor))
			If (VictimWeapon1 != none)
				Victim.RemoveItem(VictimWeapon1, 1, false, Victor)
			EndIf
			If (VictimWeapon2 != none)
				Victim.RemoveItem(VictimWeapon2, 1, false, Victor)
			EndIf
		Else
			If (VictimWeapon1 != none)
				Victim.UnequipItemEx(VictimWeapon1, 1)
			EndIf
			If (VictimWeapon2 != none)
				Victim.UnequipItemEx(VictimWeapon2, 2)
			EndIf
		EndIf
		Debug.SendAnimationEvent(Victim, "BleedOutStart")
		If (ActorFollower.GetActorRef() != None)
			Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "BleedOutStart")
		EndIf
		_SLFunctions.ReArm2(Victor)
		WRT(1.0)
		If (ActorFollower.GetActorRef() != none)
			ActorFollower.GetActorRef().StopCombat()
		EndIf
		If (Victor.IsGuard() && !Victor.IsInFaction(Companion) && !Victor.IsInFaction(OrcGuard) && (Victor.GetCrimeFaction().GetCrimeGold() <= PlayerRef.GetGoldAmount()))
			ArrestPlayer(Victor)
		ElseIf (Victor2 != none && Victor2.IsGuard() && !Victor2.IsInFaction(Companion) && !Victor2.IsInFaction(OrcGuard) && (Victor2.GetCrimeFaction().GetCrimeGold() <= PlayerRef.GetGoldAmount()))
			ArrestPlayer(Victor2)
		EndIf
		WRT(3.0)
	Else
		Victor.MoveTo(Victim, 60.0 * Math.Sin(Victim.GetAngleZ()), 60.0 * Math.Cos(Victim.GetAngleZ()))
		float zOffset1 = Victor.GetHeadingAngle(Victim)
		Victor.SetAngle(Victor.GetAngleX(), Victor.GetAngleY(), Victor.GetAngleZ() + zOffset1)
		Debug.SendAnimationEvent(Victim, "StaggerStart")
		If (ActorFollower.GetActorRef() != None)
			If (Victor != Victor2 && Victor2 != None)
				Victor2.MoveTo(ActorFollower.GetActorRef(), 60.0 * Math.Sin(ActorFollower.GetActorRef().GetAngleZ()), 60.0 * Math.Cos(ActorFollower.GetActorRef().GetAngleZ()))
				float zOffset2 = Victor2.GetHeadingAngle(ActorFollower.GetActorRef())
				Victor2.SetAngle(Victor2.GetAngleX(), Victor2.GetAngleY(), Victor2.GetAngleZ() + zOffset2)
			EndIf
			Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "StaggerStart")
		EndIf
		WRT(1.3)
		Debug.SendAnimationEvent(Victim, "BleedOutStart")
		If (ActorFollower.GetActorRef() != None)
			Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "BleedOutStart")
		EndIf
		WRT(2.0)
	EndIf
	_SLSubmitSurrenderGlobal.SetValue(0)
EndFunction

Function ArrestPlayer(Actor akGuard)
	_SLFunctions.Log("ArrestPlayer(" + akGuard + ")")

	If !_SLQuest.PrisonOverhaul
		If (_SLConfig.StealActive)
			akGuard.GetCrimeFaction().SendPlayerToJail()
		Else
			akGuard.GetCrimeFaction().SendPlayerToJail(false,true)
		EndIf
		akGuard.PushActorAway(PlayerRef, 0)
		akGuard.StopCombat()
		Game.EnablePlayerControls()
	Else
		_SLFunctions.Log("SimpleArrest(" + akGuard + ")")
		_SLQuest.xpoMain.SimpleArrest(akGuard)
	EndIf
	
	_SLSubmitJailed.SetValue(1)
EndFunction

Function PlayerRob(Actor Victim, Actor Victor)
	_SLFunctions.Log("PlayerRob(" + Victim + "," + Victor + ")")

	If (!PlayerRef.IsInCombat())
		Gold = Victim.GetGoldAmount()/10
		If (!_SLQuest.NonSentientNPC(Victor))
			int GoldSold = Utility.RandomInt(1,10)
			if (GoldSold == 1)
			Victim.RemoveItem(Gold001, Gold, true, Victor)
			Victim.RemoveItem(Gold001, Gold*9, true)
			ElseIf (GoldSold ==2)
			Victim.RemoveItem(Gold001, Gold*2, true, Victor)
			Victim.RemoveItem(Gold001, Gold*8, true)
			ElseIf (GoldSold ==4)
			Victim.RemoveItem(Gold001, Gold*3, true, Victor)
			Victim.RemoveItem(Gold001, Gold*7, true)
			ElseIf (GoldSold ==5)
			Victim.RemoveItem(Gold001, Gold*4, true, Victor)
			Victim.RemoveItem(Gold001, Gold*6, true)
			ElseIf (GoldSold ==6)
			Victim.RemoveItem(Gold001, Gold*5, true, Victor)
			Victim.RemoveItem(Gold001, Gold*5, true)
			ElseIf (GoldSold ==7)
			Victim.RemoveItem(Gold001, Gold*6, true, Victor)
			Victim.RemoveItem(Gold001, Gold*4, true)
			ElseIf (GoldSold ==8)
			Victim.RemoveItem(Gold001, Gold*7, true, Victor)
			Victim.RemoveItem(Gold001, Gold*3, true)
			ElseIf (GoldSold ==9)
			Victim.RemoveItem(Gold001, Gold*8, true, Victor)
			Victim.RemoveItem(Gold001, Gold*2, true)
			ElseIf (GoldSold ==10)
			Victim.RemoveItem(Gold001, Gold*9, true, Victor)
			Victim.RemoveItem(Gold001, Gold, true)
			EndIf
		EndIf
		WRT(1.0)
		If (_SLConfig.StealActive && !_SLQuest.NonSentientNPC(Victor))
			If (_SLConfig.SellStolen && !_SLFunctions.IsCaptured())
				PlayerSellStolenItems(Victim, Victor)
			Else
				Victim.RemoveAllItems(Victor,false,false)
			EndIf
		Else
			;Victim.UnequipAll()
		EndIf
	EndIf
EndFunction

Function PlayerSellStolenItems(Actor Victim, Actor Victor)
	_SLFunctions.Log("PlayerSellStolenItems(" + Victim + "," + Victor + ")")

	_SLFunctions.SetCaptured(true)
				
	int ItemsSoldorKept = Utility.RandomInt(1,2)
	; ==================================================================
	; Algorithm for ItemsSoldorKept more difficult levels? Just an idea
	; ==================================================================
	If (ItemsSoldorKept == 1)
		;items kept by attacker
		Victim.RemoveAllItems(Victor,false,false)
	ElseIf (ItemsSoldorKept == 2)
		;items sold so work out where they went
		int ItemsSoldLocation = Utility.RandomInt(2,6) ; 4+ Unreachable code, WIP?
		If (ItemsSoldLocation == 1)
			;items recovered by guards in Whiterun
		ElseIf (ItemsSoldLocation == 2)
			;items in Windhelm
			int SendSaleNote = Utility.RandomInt(1,2)
			
			If (SendSaleNote == 1)
				;Send a sale note to player by courier
				Victim.RemoveAllItems(MerchantWindhelmAvalAtheronChest,false,false)
				CourierChest.AddItem(_SLSubmitAvalAtheronLetter,1,true)
				WICourierItemCount.SetValue(WICourierItemCount.GetValue() + 1)
			ElseIf (SendSaleNote == 2)
				;place sale recepit on attacker for player to find
				Victim.RemoveAllItems(MerchantWindhelmAvalAtheronChest,false,false)
				Victor.AddItem(_SLSubmitLetterAvalAtheronRecepit,1,true)
			EndIf
		ElseIf (ItemsSoldLocation == 3)
			;items in Whiterun
			int SendSaleNote = Utility.RandomInt(1,2)
					
			if (SendSaleNote == 1)
				;Send a sale note to player by courier
				Victim.RemoveAllItems(MerchantWhiterunBelethorsGoodsChest,false,false)
				CourierChest.AddItem(_SLSubmitLetter,1,true)
				WICourierItemCount.SetValue(WICourierItemCount.GetValue() + 1)
			ElseIf (SendSaleNote == 2)
				;place sale recepit on attacker for player to find
				Victim.RemoveAllItems(MerchantWhiterunBelethorsGoodsChest,false,false)
				Victor.AddItem(_SLSubmitLetterBelethorRecepit,1,true)
			EndIf
		ElseIf (ItemsSoldLocation == 4)
			;items in Solitude
			int SendSaleNote = Utility.RandomInt(1,2)

			If (SendSaleNote == 1)
				;Send a sale note to player by courier
				Victim.RemoveAllItems(MerchantSolitudeBitsAndPieces,false,false)
				CourierChest.AddItem(_SLSubmitSaymaLetter,1,true)
				WICourierItemCount.SetValue(WICourierItemCount.GetValue() + 1)
			ElseIf (SendSaleNote == 2)
				;place sale recepit on attacker for player to find
				Victim.RemoveAllItems(MerchantSolitudeBitsAndPieces,false,false)
				Victor.AddItem(_SLSubmitLetterSaymaRecepit,1,true)						
			EndIf			
		ElseIf (ItemsSoldLocation == 5)
			;items in Falkreath
			int SendSaleNote = Utility.RandomInt(1,2)
			
			if (SendSaleNote == 1)
				;Send a sale note to player by courier
				Victim.RemoveAllItems(MerchantFalkreathGrayPineGoodsChest,false,false)
				CourierChest.AddItem(_SLSubmitSolafLetter,1,true)
				WICourierItemCount.SetValue(WICourierItemCount.GetValue() + 1)
			ElseIf (SendSaleNote == 2)
				;place sale recepit on attacker for player to find
				Victim.RemoveAllItems(MerchantFalkreathGrayPineGoodsChest,false,false)
				Victor.AddItem(_SLSubmitLetterSolafRecepit,1,true)						
			EndIf
		ElseIf (ItemsSoldLocation == 6)
			;items in Riften
			int SendSaleNote = Utility.RandomInt(1,2)
			
			If (SendSaleNote == 1)
				;Send a sale note to player by courier
				Victim.RemoveAllItems(MerchantRiftenPawnedPrawnChest,false,false)
				CourierChest.AddItem(_SLSubmitBersiLetter,1,true)
				WICourierItemCount.SetValue(WICourierItemCount.GetValue() + 1)
			ElseIf (SendSaleNote == 2)
				;place sale recepit on attacker for player to find
				Victim.RemoveAllItems(MerchantRiftenPawnedPrawnChest,false,false)
				Victor.AddItem(_SLSubmitLetterBersiRecepit,1,true)						
			EndIf
		EndIf
	EndIf
EndFunction

Function FollowerRob(Actor Victim)
	_SLFunctions.Log("FollowerRob(" + Victim + ")")

	mDevices = BackupDevices(Victim)
	FGold = Victim.GetGoldAmount()
	If (!_SLQuest.NonSentientNPC(ActorBully.GetActorRef()))
		Victim.RemoveItem(Gold001, FGold, false, ActorBully.GetActorRef())
	EndIf
	WRT(1.0)
	If (_SLConfig.StealActive && !_SLQuest.NonSentientNPC(ActorBully.GetActorRef()))
		Victim.RemoveAllItems(ActorBully.GetActorRef(),false,false)
		RecoverDevices(Victim, mDevices)
	Else
		Victim.UnequipAll()
		RecoverDevices(Victim, mDevices)
	EndIf
EndFunction

Armor[] Function BackupDevices(Actor Follower)
	_SLFunctions.Log("BackupDevices(" + Follower + ")")
	
	Armor[] devices = new Armor[11]
	int i = 0
	
	; Check for arm cuffs
	If Follower.WornHasKeyword(libs.zad_DeviousArmCuffs)
		devices[i] = _SLFunctions.RemoveArmCuffs(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for leg cuffs
	If Follower.WornHasKeyword(libs.zad_DeviousLegCuffs)
		devices[i] = _SLFunctions.RemoveLegCuffs(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for collar
	If Follower.WornHasKeyword(libs.zad_DeviousCollar)
		devices[i] = _SLFunctions.RemoveCollar(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for bra
	If Follower.WornHasKeyword(libs.zad_DeviousBra)
		devices[i] = _SLFunctions.RemoveBra(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for belt
	If Follower.WornHasKeyword(libs.zad_DeviousBelt)
		devices[i] = _SLFunctions.RemoveBelt(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for Harness
	If Follower.WornHasKeyword(libs.zad_DeviousHarness)
		devices[i] = _SLFunctions.RemoveHarness(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for vaginal plug
	If Follower.WornHasKeyword(libs.zad_DeviousPlugVaginal)
		devices[i] = _SLFunctions.RemoveVagPlug(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for anal plug
	If Follower.WornHasKeyword(libs.zad_DeviousPlugAnal)
		devices[i] = _SLFunctions.RemoveAnalPlug(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for armbinder
	If Follower.WornHasKeyword(libs.zad_DeviousArmbinder)
		devices[i] = _SLFunctions.RemoveArmbinder(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for boots
	If Follower.WornHasKeyword(libs.zad_DeviousBoots)
		devices[i] = _SLFunctions.RemoveBoots(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for gag
	If Follower.WornHasKeyword(libs.zad_DeviousGag)
		devices[i] = _SLFunctions.RemoveGag(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
	
	;Check for bildfold
	If Follower.WornHasKeyword(libs.zad_DeviousBlindfold)
		devices[i] = _SLFunctions.RemoveBlindFold(Follower, true)
		If devices[i] != None
			i += 1
		EndIf
	EndIf
		
	return devices
EndFunction

Function RecoverDevices(Actor Follower, Armor[] devices)
	_SLFunctions.Log("RecoverDevices(" + Follower + "," + devices + ")")

	int i = 0
	While(i < devices.Length)
		If (devices[i] != none)
			Libs.EquipDevice(Follower, devices[i], Libs.GetRenderedDevice(devices[i]), Libs.GetDeviceKeyword(devices[i]), true, false)
			i += 1
		Else
			; End reached time to jump out
			i = devices.Length
		EndIf
	EndWhile
EndFunction

event PostPlayerRape(string eventName, string argString, float argNum, form sender)
	_SLFunctions.Log("PostPlayerRape(" + eventName + "," + argString + "," + argNum + "," + sender + ")")

	Game.DisablePlayerControls()
	sslThreadController thread = SexLab.HookController(argString)
	Debug.SendAnimationEvent(PlayerRef, "IdleForceDefaultState")
	ActorAssailant1.GetActorRef().AddToFaction(_SLSubmitSatedFaction)
	If _SLConfig.RapeActive
		ReEquipBelt(playerRef, pBelt)
	EndIf
	If (ActorFollower.GetActorRef() != None)
		If _SLConfig.RapeActive
			ReEquipBelt(ActorFollower.GetActorRef(), fBelt, True)
		EndIf
		ActorAssailant2.GetActorRef().AddToFaction(_SLSubmitSatedFaction)
		sslThreadController Thread2 = SexLab.GetActorController(ActorFollower.GetActorRef())
		If (Thread2 != None && Thread2.GetState() == "Animating")
			Thread2.EndAnimation(True)
		EndIf
	EndIf
	WRT(0.5)
	Debug.SendAnimationEvent(PlayerRef, "BleedOutStart")	
	If (ActorFollower.GetActorRef() != None)
		Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "BleedOutStart")
	EndIf
	WRT(5.0)
	_SLSubmitBleedoutGlobal.SetValue(1)
	PlayerRef.DispelSpell(_SLSubmitSurrender)
	UnregisterForModEvent("AnimationEnd_PostPlayerRape")
	If ((ActorAssailant1.GetActorRef() != ActorAssailant2.GetActorRef()) && ActorAssailant2.GetActorRef() != None && ActorFollower.GetActorRef() == None)
		RoundTwo()
	Else
		;ActorUtil.RemoveAllPackageOverride(BullyPackage)
		_SLFunctions.RemovePackageFromAllActors(BullyPackage)
		If (_SLQuest.IsHostileNPC(ActorAssailant1.GetActorRef()) || _SLQuest.SentientNPC(ActorAssailant1.GetActorRef()))
			If (_SLConfig.RepeatActive)
				_SLFunctions.RecheckAssailants()
			EndIf
			If (_SLSubmitSurrenderGlobal.GetValue() != 2)
				_SLSubmitReset.Cast(PlayerRef)
				_SLFunctions.BleedOutStop()
				_SLFunctions.ClearAssailants()
				_SLSubmitBound.Cast(PlayerRef)
			EndIf
		Else
			_SLFunctions.RecheckAssailants()
			If (_SLSubmitSurrenderGlobal.GetValue() != 2)
				_SLSubmitReset.Cast(PlayerRef)
				_SLSubmitBully.Cast(PlayerRef)
				_SLFunctions.BleedOutStop()
				_SLFunctions.ClearAssailants()
				_SLSubmitBeatenGlobal.SetValue(0)
				Game.EnablePlayerControls()
			EndIf
		EndIf
	EndIf
endEvent

Function RoundTwo()
	_SLFunctions.Log("RoundTwo()")

	If (ActorAssailant2.GetActorRef() != None)
		ActorAssailant1.Clear()
		Actor Victor3 = ActorAssailant2.GetActorRef()
		Victor3.MoveTo(PlayerRef, 60.0 * Math.Sin(PlayerRef.GetAngleZ()), 60.0 * Math.Cos(PlayerRef.GetAngleZ()))
		float zOffset1 = Victor3.GetHeadingAngle(PlayerRef)
		Victor3.SetAngle(Victor3.GetAngleX(), Victor3.GetAngleY(), Victor3.GetAngleZ() + zOffset1)
		If (Victor3.HasKeyword(ActorTypeNPC))
			Debug.SendAnimationEvent(Victor3, "JumpLand")
		EndIf
		Debug.SendAnimationEvent(PlayerRef, "StaggerStart")
		WRT(0.5)
		Debug.SendAnimationEvent(PlayerRef, "BleedOutStart")
		WRT(3.5)
		float Failsafe = Utility.GetCurrentRealTime() + 3.0
		While (SexLab.FindActorController(PlayerRef) != -1 && Utility.GetCurrentRealTime() < Failsafe)
			WRT(0.1)
		EndWhile 
		If (SexLab.FindActorController(PlayerRef) == -1)
			Game.EnablePlayerControls()
			sslThreadModel thread3 = SexLab.NewThread()
			thread3.AddActor(PlayerRef, True)
			thread3.AddActor(ActorAssailant2.GetActorRef())
			thread3.DisableLeadIn()
			thread3.DisableRagdollEnd(playerRef)
			thread3.DisableUndressAnimation(PlayerRef)
			sslBaseAnimation[] anims3 = SexLab.GetAnimationsByType(2, aggressive=true)
			thread3.SetAnimations(anims3)
			RegisterForModEvent("AnimationEnd_PostPlayerRape2", "PostPlayerRape2")
			thread3.SetHook("PostPlayerRape2")
			thread3.StartThread()
		Else
			_SLSubmitBound.Cast(PlayerRef)
		EndIf
	Else
		_SLSubmitBound.Cast(PlayerRef)
	EndIf
EndFunction

event PostPlayerRape2(string eventName, string argString, float argNum, form sender)
	_SLFunctions.Log("PostPlayerRape2(" + eventName + "," + argString + "," + argNum + "," + sender + ")")

	Game.DisablePlayerControls()
	sslThreadController thread3 = SexLab.HookController(argString)
	Debug.SendAnimationEvent(PlayerRef, "IdleForceDefaultState")
	ActorAssailant2.GetActorRef().AddToFaction(_SLSubmitSatedFaction)
	WRT(0.5)
	Debug.SendAnimationEvent(PlayerRef, "BleedOutStart")	
	WRT(5.0)
	PlayerRef.DispelSpell(_SLSubmitSurrender)
	UnregisterForModEvent("AnimationEnd_PostPlayerRape")
	;ActorUtil.RemoveAllPackageOverride(BullyPackage)
	_SLFunctions.RemovePackageFromAllActors(BullyPackage)
	If (_SLQuest.IsHostileNPC(ActorAssailant2.GetActorRef()) || _SLQuest.SentientNPC(ActorAssailant2.GetActorRef()))
		If (_SLConfig.RepeatActive)
			_SLFunctions.RecheckAssailants()
		EndIf
		If (_SLSubmitSurrenderGlobal.GetValue() != 2)
			_SLSubmitReset.Cast(PlayerRef)
			_SLFunctions.BleedOutStop()
			_SLFunctions.ClearAssailants()
			_SLSubmitBound.Cast(PlayerRef)
		EndIf
	Else
		_SLFunctions.RecheckAssailants()
		If (_SLSubmitSurrenderGlobal.GetValue() != 2)
			_SLSubmitReset.Cast(PlayerRef)
			_SLSubmitBully.Cast(PlayerRef)
			_SLFunctions.BleedOutStop()
			_SLFunctions.ClearAssailants()
			_SLSubmitBeatenGlobal.SetValue(0)
			Game.EnablePlayerControls()
		EndIf
	EndIf
endEvent

Function PostPlayerRob()
	_SLFunctions.Log("PostPlayerRob()")

	
	Game.DisablePlayerControls()
	Debug.SendAnimationEvent(PlayerRef, "IdleCowering")
	WRT(2.0)
	If (ActorFollower.GetActorRef() != None)
		Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "BleedOutStop")
		WRT(0.5)
		Debug.SendAnimationEvent(ActorFollower.GetActorRef(), "IdleCowering")
	EndIf
	PlayerRef.DispelSpell(_SLSubmitSurrender)
	Debug.SendAnimationEvent(PlayerRef, "IdleForceDefaultState")
	WRT(0.1)
	If (_SLQuest.IsHostileNPC(ActorAssailant1.GetActorRef()) || _SLQuest.SentientNPC(ActorAssailant1.GetActorRef()))
		_SLSubmitBound.Cast(PlayerRef)
	Else
		If (_SLQuest.NonSentientNPC(ActorAssailant1.GetActorRef()))
			_SLSubmitBully.Cast(PlayerRef)
		EndIf
		ActorAssailant1.Clear()
		ActorAssailant2.Clear()
		Game.EnablePlayerControls()
	EndIf
	;ActorUtil.RemoveAllPackageOverride(BullyPackage)
	_SLFunctions.RemovePackageFromAllActors(BullyPackage)
	_SLFunctions.ClearAssailants()
EndFunction

Function PlayerSex(Actor[] activeActors)
	_SLFunctions.Log("PlayerSex(" + activeActors + ")")

	; Code for manual surrender to jump out
	If(_SLSubmitHardcoreBindings.GetValue() == 1 || PlayerRef.IsOnMount())
		_SLFunctions.ClearAssailants()
		_SLSubmitSurrenderGlobal.SetValue(0)
		return
	EndIf

	Actor Victim = PlayerRef
	Actor Victor = activeActors[1]
	Actor Victor2
	
	Game.DisablePlayerControls()
	
	If (activeActors.Length == 3 && activeActors[2] != None)
		Victor2 = activeActors[2]
		ActorAssailant2.ForceRefTo(Victor2)
	Else
		Victor2 = none
	EndIf
	ActorAssailant1.ForceRefTo(Victor)
	ActorBully.ForceRefTo(ActorAssailant1.GetActorRef())
	If (ActorFollowerTemp.GetActorRef() != none)
		ActorFollower.ForceRefTo(ActorFollowerTemp.GetActorRef())
		Int Cuffs2 = ActorFollower.GetActorRef().GetItemCount(_SLSubmitCuffs2)
		ActorFollower.GetActorRef().RemoveItem(_SLSubmitCuffs2, Cuffs2, true)
	EndIf
	_SLSubmitBoundGlobal.SetValue(0)
	;Int Cuffs = PlayerRef.GetItemCount(_SLSubmitCuffs)
	;Victim.RemoveItem(_SLSubmitCuffs, Cuffs, true)
	If (_SLConfig.debugActive)
		If (_SLSubmitBleedoutGlobal.GetValue() == 0)
			debug.Notification("You attempt to surrender to your opponents!")
		Else
			debug.Notification("Your opponents are not finished yet...")
		EndIf
	EndIf	
	WRT(1.0)
	;If (Victor.IsGuard() && (Victor.GetCrimeFaction().GetCrimeGold() <= PlayerRef.GetGoldAmount()))
	;	Victor.GetCrimeFaction().PlayerPayCrimeGold(true,false)
	;	Victor.StopCombat()
	;ElseIf (Victor2 != none && Victor2.IsGuard() && (Victor2.GetCrimeFaction().GetCrimeGold() <= PlayerRef.GetGoldAmount()))
	;	Victor2.GetCrimeFaction().PlayerPayCrimeGold(true,false)
	;	Victor2.StopCombat()
	;EndIf
	If (ActorFollower.GetActorRef() != none)
		ActorFollower.GetActorRef().StopCombat()
	EndIf
	Victor.StopCombat()
	If (Victor2 != none)
		Victor2.StopCombat()
	EndIf
	PlayerSurrender(Victim, Victor, Victor2)
	
	If (_SLSubmitJailed.GetValue() == 1)
		_SLSubmitJailed.SetValue(0)
		_SLFunctions.ClearAssailants()
		return
	EndIf
	
	If ((_SLQuest.IsHostileNPC(Victor) || _SLQuest.SentientNPC(Victor) || _SLQuest.NonSentientNPC(Victor)) && (Victor2 == None || _SLQuest.IsHostileNPC(Victor2) || _SLQuest.SentientNPC(Victor2) || _SLQuest.NonSentientNPC(Victor2)) || (_SLSubmitJailed.GetValue() == 0 && PlayerRef.IsInInterior()))
		_SLSubmitFollowerSpell.Cast(PlayerRef)
		PlayerRob(Victim,Victor)
		
		If (ActorFollower.GetActorRef() != none)
			FollowerRob(ActorFollower.GetActorRef())
		EndIf
		
		If PlayerRef.WornHasKeyword(Libs.zad_DeviousArmbinder)
			_SLFunctions.RemoveArmbinder(PlayerRef, false)
		EndIf
		
		If ActorFollower.GetActorRef() != None && ActorFollower.GetActorRef().WornHasKeyword(Libs.zad_DeviousArmbinder)
			_SLFunctions.RemoveArmbinder(ActorFollower.GetActorRef(), True)
		EndIf
		
		If(_SLConfig.RapeActive)
			Game.EnablePlayerControls()
			_SLSubmitBeatenGlobal.SetValue(1)
			If (activeActors.Length >= 2)
				pBelt = RemoveBelt(playerRef)
				sslThreadModel Model = SexLab.NewThread()
				Model.AddActor(Victim, True)
				Model.AddActor(Victor)
				Model.DisableLeadIn()
				Model.DisableRagdollEnd(Victim)
				Model.DisableUndressAnimation(Victim)
				Model.DisableRedress(Victim)
				sslBaseAnimation[] anims = SexLab.GetAnimationsByType(2, aggressive=true)
				Model.SetAnimations(anims)
				RegisterForModEvent("AnimationEnd_PostPlayerRape", "PostPlayerRape")
				Model.SetHook("PostPlayerRape")
				Model.StartThread()
				If (activeActors.Length > 2 && ActorFollower.GetActorRef() != None)
					If (_SLConfig.debugActive && _SLSubmitBleedoutGlobal.GetValue() != 0)
						Debug.Notification(ActorFollower.GetActorRef().GetBaseObject().GetName() + " surrenders to your assailant!")
					EndIf
					fBelt = RemoveBelt(ActorFollower.GetActorRef(), True)
					sslThreadModel Model2 = SexLab.NewThread()
					Model2.AddActor(ActorFollower.GetActorRef(), True)
					Model2.AddActor(Victor2)
					Model2.DisableLeadIn()
					Model2.DisableRagdollEnd(ActorFollower.GetActorRef())
					Model2.DisableUndressAnimation(ActorFollower.GetActorRef())
					Model2.DisableRedress(ActorFollower.GetActorRef())
					sslBaseAnimation[] anims2 = SexLab.GetAnimationsByType(2, aggressive=true)
					Model2.SetAnimations(anims2)
					Model2.StartThread()
				EndIf
			EndIf
		Else
			PostPlayerRob()
		EndIf
	Else
		If (!playerRef.IsInCombat())
			PostPlayerRob()
		Else
			_SLFunctions.CombatRecover()
		EndIf
	EndIf
EndFunction

Armor[] Function RemoveBelt(Actor akActor, Bool skipEvents = False)
	_SLFunctions.Log("RemoveBelt(" + akActor + "," + skipEvents + ")")
	int i = 0
	Armor[] devices = new Armor[3]
	
	If playerRef.WornHasKeyword(Libs.zad_DeviousBelt)
		devices[0] = _SLFunctions.RemoveBelt(akActor, skipEvents)
	EndIf
	If akActor.WornHasKeyword(Libs.zad_DeviousPlugVaginal)
		devices[1] = _SLFunctions.RemoveVagPlug(akActor, skipEvents)
	EndIf
	If akActor.WornHasKeyword(Libs.zad_DeviousPlugAnal)
		devices[2] = _SLFunctions.RemoveAnalPlug(akActor, skipEvents)
	EndIf
	
	return devices
EndFunction

Function ReEquipBelt(Actor akActor, Armor[] beltDevices, Bool skipEvents = False)
	_SLFunctions.Log("ReEquipBelt(" + akActor + "," + beltDevices + "," + skipEvents + ")")

	Int i = beltDevices.Length
	While  i >= 0
		If beltDevices[i] != None
			Libs.EquipDevice(akActor, beltDevices[i], Libs.GetRenderedDevice(beltDevices[i]), Libs.GetDeviceKeyword(beltDevices[i]), skipEvents, false)
		EndIf
		i -= 1
	EndWhile
EndFunction

event PostCoitalBliss(string eventName, string argString, float argNum, form sender)
	_SLFunctions.Log("PostCoitalBliss(" + eventName + "," + argString + "," + argNum + "," + sender + ")")

	sslThreadController thread = SexLab.HookController(argString)
	actor[] actorList = SexLab.HookActors(argString)
	PlayerRef.RemoveSpell(_SLSubmitIndecency)
	ActorPostSexPartner.ForceRefTo(ActorSexPartner.GetActorRef())
	WRT(0.1)
	_SLSubmitSexPartner.SetValue(0)
	ActorSexPartner.Clear()
	If (_SLSubmitIndecencyGlobal.GetValue() == 0)
		WRT(1.0)
		If (actorList[0] != PlayerRef)
			actorList[0].Say(_SLSubmitBlissTopic)
			If (actorList[0].IsGuard())
				actorList[0].RemoveSpell(Privacy)
			EndIf
			If (actorList[0].IsInFaction(_SLSubmitRejectedFaction))
				actorList[0].RemoveFromFaction(_SLSubmitRejectedFaction)
			EndIf
			If (!actorList[0].IsInFaction(_SLSubmitLoverFaction))
				actorList[0].AddToFaction(_SLSubmitLoverFaction)
			EndIf
			If (actorList[0].IsInFaction(_SLSubmitPartnerFaction))
				actorList[0].RemoveFromFaction(_SLSubmitPartnerFaction)
			EndIf
			If (actorList[0].IsInFaction(_SLSubmitTempRank1Faction))
				actorList[0].SetRelationshipRank(PlayerRef,0)
				actorList[0].RemoveFromFaction(_SLSubmitTempRank1Faction)
			EndIf
			If (actorList[0].GetRelationshipRank(PlayerRef) < 4)
				actorList[0].SetRelationshipRank(PlayerRef, (actorList[0].GetRelationshipRank(PlayerRef) + 1))
				If(_SLConfig.debugActive)
					Debug.Notification("Your relationship with your recent partner has improved to " + actorList[0].GetRelationshipRank(PlayerRef) +"!")
				EndIf
			EndIf
		EndIf
		WRT(1.0)
		If (actorList[1] != PlayerRef && actorList[0] != actorList[1])
			actorList[1].Say(_SLSubmitBlissTopic)
			If (actorList[1].IsGuard())
				actorList[1].RemoveSpell(Privacy)
			EndIf
			If (actorList[1].IsInFaction(_SLSubmitRejectedFaction))
				actorList[1].RemoveFromFaction(_SLSubmitRejectedFaction)
			EndIf
			If (!actorList[1].IsInFaction(_SLSubmitLoverFaction))
				actorList[1].AddToFaction(_SLSubmitLoverFaction)
			EndIf
			If (actorList[1].IsInFaction(_SLSubmitPartnerFaction))
				actorList[1].RemoveFromFaction(_SLSubmitPartnerFaction)
			EndIf
			If (actorList[1].IsInFaction(_SLSubmitTempRank1Faction))
				actorList[1].SetRelationshipRank(PlayerRef,0)
				actorList[1].RemoveFromFaction(_SLSubmitTempRank1Faction)
			EndIf
			If (actorList[1].GetRelationshipRank(PlayerRef) < 4)
				actorList[1].SetRelationshipRank(PlayerRef, (actorList[1].GetRelationshipRank(PlayerRef) + 1))
				If(_SLConfig.debugActive)
					Debug.Notification("Your relationship with your recent partner has improved to " + actorList[1].GetRelationshipRank(PlayerRef) +"!")
				EndIf
			EndIf
		EndIf
	Else
		_SLSubmitIndecencyGlobal.SetValue(0)
	EndIf
	ActorPostSexPartner.Clear()
	UnregisterForModEvent("AnimationEnd_PostCoitalBliss")
endEvent

event PostRescueSex(string eventName, string argString, float argNum, form sender)
	_SLFunctions.Log("PostRescueSex(" + eventName + "," + argString + "," + argNum + "," + sender + ")")

	sslThreadController thread = SexLab.HookController(argString)
	actor[] actorList = SexLab.HookActors(argString)
	WRT(5.0)
	If(_SLConfig.debugActive)
		Debug.Notification("Your 'rescuer' tosses you a few coins.")
	EndIf
	If (actorList[0] != PlayerRef)
		actorList[0].Say(_SLSubmitRescueTopic)
		PlayerRef.AddItem(Gold001,Utility.RandomInt(10,25))
	EndIf
	WRT(1.0)
	If (actorList[1] != PlayerRef)
		actorList[1].Say(_SLSubmitRescueTopic)
		PlayerRef.AddItem(Gold001,Utility.RandomInt(10,25))
	EndIf
	UnregisterForModEvent("AnimationEnd_PostRescueSex")
endEvent